;**********************************************
; Test write and read EEPROM 24128
; Hardware  : CP-PIC V3.0/4.0
; OSC   10MHz
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 01/8/2002
;**********************************************
; STEP to follow when test this program
;    1.Connect RS232 or RS422 cable between board and PC.
;    2.Download this program to CPU.
;    3.Run terminal program such as Procom plus,XTALK etc.
;    4.Set parameter Procom plus to 9600 baud,No parity,8 bits data and 1 bit. stop
;    5.Reset board ,after reset board you will see this message on PC.
;
;         "DATA EEPROM"
;	   "00 01 02 03 04 05 06 07 08 09"
;       
;*************************************************

     LIST P=18f458
     include <p18f458.inc>

#define   SDA_BIT     PORTC,4  
#define   SCL_BIT     PORTC,3

DT1       EQU       0x20
DT2       EQU       0x21
DT3       EQU       0X22
RD_BUF    EQU       0x23
WR_BUF    EQU       0x24
COUNT     EQU       0x25
COUNT10   EQU	    0x26
DAT       EQU       0x27
B1        EQU       0x28
B2        EQU       0x29

;*********************************************
          ORG       0x0000
          
          BCF       TRISC,4        ; PORTC.3 as output
          BCF       TRISC,3        ; PORTC.4 as input
          MOVLW     0x40           ; BAUD rate 9600
          MOVWF     SPBRG
          CLRF      TXSTA          ; 8 bits data ,no,1 stop
          BSF       TXSTA,TXEN     ; Transmit enable
	  BSF	    TXSTA,BRGH     ; hi speed
	  BSF       RCSTA,SPEN     ; Asynchronous serial port enable
          BSF       RCSTA,CREN     ; continuous receive
	  
          MOVLW	    .10	           ; counter for data to write
	  MOVWF     COUNT10
	               
          CALL	    START	   ; start condition
          MOVLW     0xA8           ; control byte
          CALL      WR_I2C         ; write data to eeprom 
	  MOVLW     0              ; address high byte = 00
          CALL	    WR_I2C   
	  MOVLW	    0		   ; address low byte = 00
	  CALL      WR_I2C

	  CLRF      DAT	           ; start data = 00
WR_EEP	  MOVF	    DAT,W          ; write loop  
          CALL	    WR_I2C         ; write data to eeprom
	  INCF	    DAT,f	   ; data = data+1
	  DECFSZ    COUNT10        ; check counter loop
	  GOTO	    WR_EEP
	  
	  CALL      STOP	   ; stop condition
	  CALL      ACK_P          ; acknoledge pulling
          CALL      SDEL           ; delay more than 10 mS

          MOVLW     0x0C           ; Clear display
          CALL      SEND
          MOVLW     "D"
          CALL      SEND
          MOVLW     "A"
          CALL      SEND
          MOVLW     "T"
          CALL      SEND
          MOVLW     "A"
          CALL      SEND
          MOVLW     " "
          CALL      SEND
          MOVLW     "E"
          CALL      SEND        
	  MOVLW     "E"
          CALL      SEND
          MOVLW     "P"
          CALL      SEND
          MOVLW     "R"
          CALL      SEND
          MOVLW     "O"
          CALL      SEND
          MOVLW     "M"
          CALL      SEND
         
          MOVLW     0xA             ; new line
          CALL      SEND
          MOVLW     0xD
          CALL      SEND
 	  MOVLW     " "
	  CALL      SEND

;*********** READ DATA FORM EEPROM *************
	  
	  CLRF	    DAT	           ; start Address data = 00
  	  MOVLW	    .10		   ; counter for loop = 10
	  MOVWF     COUNT10
RD_EEP    CALL	    START
          MOVLW     0xA8           ; control byte
          CALL	    WR_I2C
	  MOVLW	    0x0		   ; address high byte
	  CALL      WR_I2C	  
	  MOVF	    DAT,W	   ; address low byte of DAT
	  CALL	    WR_I2C
	  CALL	    START	   ; start condition
	  MOVLW	    0xA9	   ; control byte read
	  CALL	    WR_I2C
		  	    
NN	  CALL	    RD_I2C	   ; read 8 bit data
	  MOVF      RD_BUF,W	   ; save data to w
	  CALL      ADJT           ; display data
	  MOVLW     " "
          CALL      SEND
	 
	  DCFSNZ    COUNT10	   ; check counter
	  GOTO      RD_END	   ; count10 = '0'
	 
	  INCF	    DAT,F	   ; count10 = '1'
	  GOTO      RD_EEP

RD_END	  CALL	    N_ACK	   ; send no ack
	  CALL	    STOP	   ; stop condition
	  GOTO	    $



;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      MOVWF     B1             ; B1 = HHHH LLLL
          SWAPF     B1,W           ; W  = LLLL HHHH
          ANDLW     0x0F           ; Mask upper four bits 0000 HHHH
          ADDLW     0x30           ; convert to ASCII
          CALL      SEND           ; Send first digit
          MOVF      B1,W
          ANDLW     0x0F           ; w  = 0000 LLLL
          ADDLW     0x30           ; convert to ASCII
          CALL      SEND
          RETURN

;********************************************************
; Send data to RS-232 9600 Buad,8 bits data, No parity, 1 stop
; Input  : W
; Output : Computer screen
;********************************************************
SEND      MOVWF     TXREG          ; Send recent data to TX 
WAIT      LFSR      0,TXSTA
          BTFSS     INDF0,1        ; check TRMT bit in TXSTA register
	  GOTO      WAIT           ; TXREG full  or TRMT = 0
          RETURN


;****************** WRITE DATA TO I2C BUS ************************

WR_I2C		MOVWF	WR_BUF	   ; load data to buffer
		MOVLW	.8	   ; counter = 8
		MOVWF	COUNT
		CALL	SCL_LOW
		CALL    DELAY
WR_LOOP	        RLCF	WR_BUF,F   ; rotate carry to buffer
		BC	SEND_1     ; goto SEND_1 when carry = 1
SEND_0		CALL    SDA_LOW    ; carry flag = 0
		CALL	PULSE      ; send clock
		GOTO	CHECK      ; check counter
SEND_1		CALL	SDA_HIGH   ; carry flag = 1
		CALL	PULSE      ; send clock
CHECK		DECFSZ	COUNT,F    ; check counter
		GOTO	WR_LOOP
		CALL	SDA_HIGH
		CALL	RD_ACK     ; read acknowledge
		RETURN 

;*********** READ DATA FORM I2C BUS **************

RD_I2C		MOVLW	.8         ; counter = 8
		MOVWF	COUNT
		CLRF    RD_BUF     ; clear buffer
		CALL	SCL_LOW
		CALL	SDA_HIGH
RD_LOOP	        CALL	SCL_HIGH   ; pulse Hi
		BTFSC	SDA_BIT    ; check data form bit SDA
		GOTO	RD_1       ; data = 1
RD_0		BCF     STATUS,C   ; clear carry flag
		GOTO	ROTATE     
RD_1		BSF     STATUS,C   ; set carry flag
ROTATE		RLCF	RD_BUF,F   ; rotate carry flag to buffer
		CALL	SCL_LOW	   ; pulse Low
		DECFSZ	COUNT,F    ; check counter
		GOTO	RD_LOOP
		RETURN

;********  READ ACK **************
RD_ACK  	CALL	SDA_HIGH   
		CALL	SCL_LOW
		CALL	SCL_HIGH
		BTFSC	SDA_BIT    ; test bit SDA
		GOTO	STOP       ; No acknowledge
		BTFSS	SCL_BIT
		GOTO	$-1
	        CALL	SCL_LOW          
		CALL    DELAY
		RETURN

;******** SEND ACK ************
S_ACK	        CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SCL_LOW
		CALL	SDA_HIGH
		RETURN

;********  SEND NACK *********
N_ACK	        CALL	SCL_LOW
		CALL	SDA_HIGH
		CALL	SCL_HIGH
		CALL	SCL_LOW
		RETURN

;*********** ACK POLLING **********
ACK_P   	CALL	SCL_LOW
		CALL	START		; start condition
		MOVLW	0XA8	        ; control address A8H
		CALL	WRITE           ; write 8 bit data to I2C
        	CALL	SDA_HIGH        
		CALL	SCL_LOW
		CALL	SCL_HIGH
		BTFSC	SDA_BIT		; check SDA
		GOTO	ACK_P
		CALL	SCL_LOW
		RETURN

WRITE		MOVWF	WR_BUF		; data to buffer
		MOVLW	.8		; counter = 8
		MOVWF	COUNT
		CALL	SCL_LOW		
		CALL    DELAY
RO_TATE	        RLCF	WR_BUF,F	; rotate data(MSB) to carry flag
		BC	SEND1	        ; data = 1 jump to SEND1
SEND0		CALL    SDA_LOW	        ; data = 0 
		CALL	PULSE		; clock
		GOTO	CHK		; check counter
SEND1		CALL	SDA_HIGH	; data = 1
		CALL	PULSE		; clock
CHK		DECFSZ	COUNT,F	 	; check counter
		GOTO	RO_TATE
		CALL	SDA_HIGH
		RETURN 

;******************************
; Start bit
;******************************
START		CALL	SDA_HIGH
		CALL	SCL_HIGH
		BTFSS	SCL_BIT
		GOTO	$-1
		BTFSS	SDA_BIT
		GOTO	$-1
		CALL	SDA_LOW
		CALL	SCL_LOW
		RETURN

;********  STOP *************
STOP		CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SDA_HIGH
		CALL	DELAY
		RETURN

;******** SCL PULSE *************** 
PULSE    	CALL	SCL_LOW
	        CALL    DELAY
		CALL	SCL_HIGH
	        CALL    DELAY
		CALL	SCL_LOW
		RETURN

;********** SCL HIGH ********************
SCL_HIGH	BSF	TRISC,3
		RETURN

;******** SCL LOW **********************
SCL_LOW		BCF	TRISC,3
		BCF	SCL_BIT
		RETURN

;******** SDA HIGH ********************
SDA_HIGH	BSF	TRISC,4
		RETURN

;********  SDA  LOW *****************
SDA_LOW		BCF	TRISC,4
		BCF	SDA_BIT
		RETURN       
;******************************
; DELAY TIME
;******************************
DELAY     MOVLW	    .5
	  MOVWF	    DT1
	  DECFSZ    DT1,F
	  GOTO	    $-1
	  RETURN

SDEL      MOVLW     0x00
          MOVWF     DT1
SD2       MOVLW     0x00
          MOVWF     DT2
SD1       DECFSZ    DT2
          GOTO      SD1
          DECFSZ    DT1
          GOTO      SD2
          RETURN
	
	END

